<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('full_name', 'phone', 'hospital_id', 'medical_records', 'ktp', 'golongan_darah', 'alergi');
    protected $visible = array('full_name', 'phone', 'hospital_id', 'golongan_darah');

    public function hospital()
    {
        return $this->belongsTo('App\Models\Hospital', 'hospital_id');
    }

}